#               -------------
#                   Links
#               -------------
#               Links Manager
#
#         File: site_html.pl
#  Description: This library contains all the HTML that will be generated in
#               the finished directory.
#       Author: Alex Krohn
#        Email: alex@gossamer-threads.com
#          Web: http://www.gossamer-threads.com/
#      Version: 2.0
#
# (c) 1998 Gossamer Threads Inc. 
#
# This script is not freeware! Please read the README for full details
# on registration and terms of use. 
# =====================================================================

# ----------------------------------------------------------------------
# The HTML in this file and the style sheet (links.css) have been authored
# by Chris Croome of webarchitects. 
#
#        Email: chris@atomism.demon.co.uk
#          Web: http://www.webarchitects.co.uk/
# ----------------------------------------------------------------------

# You can put variables here that you would like to use in any
# of your templates.

    %globals = (
                    date           => &get_date,
                    time           => &get_time,
                    db_cgi_url     => $db_cgi_url,
                    build_root_url => $build_root_url,
                    build_home_url => $build_home_url,
                    site_title     => $build_site_title,
                    go_top_category => &go_top_category,
                    build_css_url  => $build_css_url,
               	  banner         => ''
        );
$new_1 = qq|<img src="$build_root_url/Images/new_1.gif" border="0" width=34 height=12 alt="New0-2" align="absmiddle">|;
$new_3 = qq|<img src="$build_root_url/Images/new_3.gif" border="0" width=34 height=12 alt="New3-7" align="absmiddle">|;
$new_7 = qq|<img src="$build_root_url/Images/new_7.gif" border="0" width=34 height=12 alt="New8-14" align="absmiddle">|;

sub site_html_link {
# --------------------------------------------------------
# This routine is used to display what a link should look
# like. 

    my %rec = @_;
    my $days_old = &days_old($rec{'¥'});
  	 my $new_img = "";    

	($rec{'õ'} eq 'Yes') ? ($rec{'õ'} = 1) : (delete $rec{'õ'});

# Set new and pop to either 1 or 0 for templates.
  if ($days_old <= 2) { $new_img = $new_1; }
  elsif ($days_old <= 7) { $new_img = $new_3; }
  elsif ($days_old <= 14) { $new_img = $new_7; }
  else { (delete $rec{'ű'}); }

    return &load_template ('link.html', { 
    													  new_img => $new_img,
                                            detailed_url => "$build_detail_url/$rec{'ID'}$build_extension",
                                            %rec,
                                            %globals
                                    });
}

sub site_html_home {
# --------------------------------------------------------
# This routine will build a home page. It is not meant to have any 
# links on it, only subcategories.

    return &load_template ('home.html', { 
                                      'īװ' => $category, 
                                      grand_total => $grand_total,
                                      %globals
                            });
}

sub site_html_new {
# --------------------------------------------------------
# This routine will build a what's new page. 

    return &load_template ('new.html', {
                                        total => $total,
                                        grand_total => $grand_total,
                                        link_results => $link_results,
                                        title_linked => $title_linked,
                                        %globals
                                    } );
}

sub site_html_cool {
# --------------------------------------------------------
# This routine will build a what's new page. 

    return &load_template ('cool.html', {
                                        total => $total,
                                        grand_total => $grand_total,
                                        percent => $percent,
                                        link_results => $link_results,
                                        title_linked => $title_linked,
                                        %globals
                                    } );
}

sub site_html_detailed {
# --------------------------------------------------------
# This routine will build a single page per link. It's only
# really useful if you have a long review for each link --
# or more information then can be displayed in a summary.
#
    my %rec = @_;
    return &load_template ('detailed.html', {
                                        total => $total,
                                        grand_total => $grand_total,
                                        title_linked => $title_linked,
                                        %rec,
                                        %globals
                                    } );
}

sub site_html_category {
# --------------------------------------------------------
# This rountine will build a page based for the current category.

    return &load_template ( 'category.html', {
                                        date => $date,
                                        time => $time,
                                        'īװ' => $category,
                                        links => $links,
                                        title_linked => $title_linked,
                                        title => $title,
                                        total => $total,
                                        grand_total => $grand_total,
                                        category_name => $category_name,
                                        directory_name => $directory_name,
                                        category_name_escaped => $category_name_escaped,
                                        category_clean => $category_clean,
                                        description => $description,
                                        meta_name => $meta_name,
                                        meta_keywords => $meta_keywords,
                                        header => $header,
                                        footer => $footer,
                                        prev => $prev,
                                        next => $next,
                                        related => $related,
                                        build_links_per_page => $build_links_per_page,
                                        %globals
                                    } );
}

sub site_html_ratings {
# --------------------------------------------------------
# This routine determines how the top rated page will look like.

    return &load_template ( 'rate_top.html', {
                                                top_rated => $top_rated,
                                                top_votes => $top_votes,
                                                %globals
                                            });
}

########################################################################################
# THE FOLLOWING ARE CGI GENERATED PAGES AND THE TEMPLATE MUST BE PRINTED, NOT RETURNED!#
########################################################################################

sub site_html_add_form {
# --------------------------------------------------------
# This routine determines how the add form page will look like. 
#
    &html_print_headers;

  my $category = shift;
  my ($cat_korean, @data, @lines);
  
open(DATA,"$db_category_name");
   @lines = <DATA>;
close(DATA);
	
	  foreach $line (@lines) {
	  		@data=split(/\|/,$line);
	  			if ($category eq $data[1]) { $cat_korean = $data[3]; }
		}
if ($category) {
      $category = qq~$cat_korean <input type=hidden name="īװ" value="$category">~;
  }
  else {
    if (!@exclude_categories) {
      ($category = &build_select_field ("īװ"));
    }
    else {
      ($category = &get_cat_select_list);
    }
  }
    
    print &load_template ('add.html', { 
                                        'īװ' => $category,
                                        %globals
                                    });
}

sub site_html_add_success {
# --------------------------------------------------------
# This routine determines how the add success page will look like. 

    &html_print_headers;
  		my ($cat_korean, @data, @lines);
			
			open(DATA,"$db_category_name");
   			@lines = <DATA>;
			close(DATA);
	
	  foreach $line (@lines) {
	  		@data=split(/\|/,$line);
	  			if ($in{'īװ'} eq $data[1]) { $cat_korean = $data[3]; }
		}
    $in{'īװ'} = $cat_korean;

    print &load_template ('add_success.html', { 
                                        %in,
                                        %globals
                                    });
}

sub site_html_add_failure {
# --------------------------------------------------------
# This routine determines how the add failure page will look like. 

    	my ($errormsg) = shift;
  		my ($cat_korean, @data, @lines);
			
			open(DATA,"$db_category_name");
   			@lines = <DATA>;
			close(DATA);
	
	  foreach $line (@lines) {
	  		@data=split(/\|/,$line);
	  			if ($in{'īװ'} eq $data[1]) { $cat_korean = $data[3]; }
		}
    $in{'īװ'} ? 
        ($in{'īװ'} = qq~<input type=hidden name="īװ" value="$in{'īװ'}">$cat_korean~) :
        ($in{'īװ'} = &get_cat_select_list);
    
    &html_print_headers;    
    print &load_template ('add_error.html', { 
                                        error => $errormsg,
                                        %in,
                                        %globals
                                    });
}

sub site_html_modify_form {
# --------------------------------------------------------
# This routine determines how the modify form page will look like. 

if (!@exclude_categories) {
    ($category = &build_select_field ("īװ"));
  }
  else {
    ($category = &get_cat_select_list);
  }
  
    &html_print_headers;
    print &load_template ('modify.html', { 
                                        'īװ' => $category,
                                        %globals
                                    });
}    

sub site_html_modify_success {
# --------------------------------------------------------
# This routine determines how the modify success page will look like. 

    &html_print_headers;
  		my ($cat_korean, @data, @lines);
			
			open(DATA,"$db_category_name");
   			@lines = <DATA>;
			close(DATA);
	
	  foreach $line (@lines) {
	  		@data=split(/\|/,$line);
	  			if ($in{'īװ'} eq $data[1]) { $cat_korean = $data[3]; }
		}
    $in{'īװ'} = $cat_korean;    
    print &load_template ('modify_success.html', {
                                        %in,
                                        %globals
                                });
}

sub site_html_modify_failure {
# --------------------------------------------------------
# This routine determines how the modify failure page will look like. 

    	my $errormsg    = shift;
  		my ($cat_korean, @data, @lines);
			
			open(DATA,"$db_category_name");
   			@lines = <DATA>;
			close(DATA);
	
	  foreach $line (@lines) {
	  		@data=split(/\|/,$line);
	  			if ($in{'īװ'} eq $data[1]) { $cat_korean = $data[3]; }
	  	}
	  	
  if ($in{'īװ'}) {
    ($in{'īװ'} =
    qq~$cat_korean<input type=hidden name="īװ" value="$in{'īװ'}">~);
  } else {
    	if (!@exclude_categories) {
      	($in{'īװ'} = &build_select_field ("īװ"));
    	} else {
      		($in{'īװ'} = &get_cat_select_list);
    		}
  	}

    &html_print_headers;
    print &load_template ('modify_error.html', {
                                        error => $errormsg,
                                        %in,
                                        %globals
                                });
}

sub site_html_search_results {
# --------------------------------------------------------
# This routine displays the search results.
# 
    my $term    = &urlencode ($in{'search'});
    &html_print_headers;
    print &load_template ('search_results.html', {
                                        term => $term,
                                        link_results => $link_results,
                                        category_results => $category_results,
                                        next => $next,
                                        cat_hits => $cat_hits,
                                        link_hits => $link_hits,
                                        %in,
                                        %globals
                                    });
}

sub site_html_search_failure {
# --------------------------------------------------------
# This routine displays a failed search page with error in $error.
#
    my $error = shift;
    my $term    = &urlencode ($in{'search'});
    &html_print_headers;

    print &load_template ('search_error.html', {
                                        term => $term,
                                        error => $error,
                                        %in,
                                        %globals
                                    });
}    

sub site_html_search_form {
# --------------------------------------------------------
# This routine displays the search form.

    &html_print_headers;
    print &load_template ('search.html', {
                                        term => $term,
                                        error => $error,
                                        %in,
                                        %globals
                                    });
}

sub site_html_mailing {
# --------------------------------------------------------
# This routine displays your mailing list subscribe/unsubscribe form.
#
    my $action = shift;
    my $message;
    ($action eq 'subscribe')   and ($message = qq~ϸƮ  ԵǾϴ!~);
    ($action eq 'unsubscribe') and ($message = qq~ϸƮ   Ǿϴ.!~);

    &html_print_headers;
    print &load_template ('email.html', {
                                        message => $message,
                                        %in,
                                        %globals
                                    });
}

sub site_html_mailing_error {
# --------------------------------------------------------
# This routine is displayed if there was a problem subscribing.
#
    my $error = shift;

    &html_print_headers();
    print &load_template ('email_error.html', {
                                        error => $error,
                                        %in,
                                        %globals
                                    });
}

sub site_html_rate_form {
# --------------------------------------------------------
# This routine determines how the rate form page will look like. 
#
    my %rec = @_;
    
    &html_print_headers;
    print &load_template ('rate.html', { 
                                        %rec,
                                        %globals
                                    });
}

sub site_html_rate_success {
# --------------------------------------------------------
# This routine determines how the rate success page will look like. 

    &html_print_headers;
    print &load_template ('rate_success.html', { 
                                        %in,
                                        %globals
                                    });
}

sub site_html_rate_failure {
# --------------------------------------------------------
# This routine determines how the rate failure page will look like. 

    my ($errormsg) = shift;

    &html_print_headers;    
    print &load_template ('rate_error.html', { 
                                        error => $errormsg,
                                        %in,
                                        %globals
                                    });

}

########################################################################################
# THE FOLLOWING DETERMINES YOUR CATEGORY LISTING, IT'S NOT TEMPLATE BASED (YET)!       #
########################################################################################

sub site_html_print_cat {
# --------------------------------------------------------
# This routine determines how the list of categories will look.
# We now use a table to split the category name up into two columns.
# For each category you can use the following variables:
#
#   $url        : The URL to go to that category
#   $category_name : The category name with _ and / removed.
#   $category_descriptions{$subcat}: The category description (if any).
#   $numlinks   : The number of links inside that category (and subcategories).
#   $mod        : The newest link inside of that category.
#

    my (@subcat) = @_; 
    my ($cat_real, $url, $numlinks, $mod, $subcat, $category_name, $description, $output, $i, @subcatsub, $length, $s);
	 my $breakpoint = int (($#subcat+1) / $build_category_columns) + ( (($#subcat+1) % $build_category_columns) ? 1 : 0);
	 my $td_width = int(100 / $build_category_columns);
	 
    $output = qq|<table width="100%" border="0" cellspacing="0" cellpadding="0">
    						<tr>
    							<td valign="top">\n|;
    $i = 0;
    
   foreach $subcat (sort @subcat) { 
   	($cat_real) = @{$category{$subcat}}[3];
		if ($cat_real eq "") {
			if ($subcat =~ m,.*/([^/]+)$,) { 
				$category_name = &build_clean($1); 
			} else { $category_name = &build_clean($subcat); }
		} else { $category_name = &build_last_title_kor($cat_real); }

		if ($subcat =~ /\@$/) {
			($subcat) = @{$category{$subcat}}[2];
		}

	($description) = @{$category{$subcat}}[2];
	$url = "$build_root_url/" . &urlencode($subcat) . "/";
   	$numlinks = $stats{"$subcat"}[0]; 
   	$mod = $stats{"$subcat"}[1];
	($i and ($i % $breakpoint)) or ($output .= qq|</td><td width="$td_width%" valign="top">\n|);
        $i++;
        
       my $days_old = &days_old($mod); 
       
       if ($category_name =~ s/\@$//g) {
       $output .= qq|<dt><font face="" size=2>&nbsp;&#149; <b><a href="$url">$category_name</a></b></font><img src="$build_root_url/Images/inherit.gif" width="16" height="11" border="0" align="adsmiddle">|;
       NEXT
       } elsif ($subcat =~ m,.*/([^/]+)$,) { 
		 $output .= qq|<dt><font face="" size=2>&nbsp;&#149; <b><a href="$url">$category_name</a></b></font> <font face="" size=2>($numlinks)</font>|;
       } else {
       $output .= qq|<dt><font face="" size=2><b><a href="$url">$category_name</a></b></font> <font face="" size=2>($numlinks)</font>|;
       }
 			if ($subcat =~ m,.*/([^/]+)$,) {	
 				if ($days_old <= 2) { $output .= qq| $new_1|; }
  				elsif ($days_old <= 7) { $output .= qq| $new_3|; }
  				elsif ($days_old <= 14) { $output .= qq| $new_7|; }
  			}
  		$output .= qq|</dt>|;
  			
if ($description =~ m,^\(([^\)]+)\)(\d)$, && $#{$subcategories{$subcat}} >= 0) {
	($description, $style) = ($1, $2);
	$s = 0;
	@subcatsub = split (/\|/, $description);
$output .= qq~<br>~;	
	foreach $category_name (@subcatsub) {
		foreach (sort @{$subcategories{$subcat}}) {
			@sub_dir = split (/:/, $_);
			($description eq "SUB" && $#subcatsub == 0) ?
				($_ =~ m,.*/([^/]+)$, and $category_name = &build_last_kor($1)) :
				($_ eq "$subcat/$category_name" or next);
			if ($_ =~ /\@$/) { NEXT }
			else {
				if ($style eq "1") {
				$length += length($category_name);	
				($length > $subcat_length) and last;
				}
					if ($s > 0) {
					$output .= qq~, ~ and $length += 2 if ($style eq "1");
					$output .= qq~<br>~ if ($style eq "2");
				}
				$url = "$build_root_url/" . &urlencode($_) . "/";
				$output .= qq~  ~ if ($style eq "2");
				$output .= qq~<font size=2><a href="$url">$category_name</a></font>~;
				$s++;
				last if ($description ne "SUB" && $#subcatsub > 0);
			}
		}
	}	
	undef $length;
		if ($s < $#{$subcategories{$subcat}}) {
			$output .= qq~...~ if ($style eq "1");
		}
}
else { $output .= qq~<br><font size=2>$description</font>~ if (!($description =~ /^[\s\n]*$/)); }
$output .= qq|
      <table width="100%" cellpadding="0" cellspacing="0" border="0">
          		<tr>
          			<td height="5"><spacer type="block" width="1" height="5"></td>
          		</tr>
      </table>|;       

   }
    $output .= "</td></tr></table>\n";
    return $output;
}

sub top_cat_select_list {
# --------------------------------------------------------
# ֻ īװ ̵ ƾ.

  my (@subcat) = @_; 
  my $output;
                           
  CAT: foreach $subcat (sort @subcat) { 
  	($cat_real) = @{$category{$subcat}}[3];
    if (@exclude_categories) {
      foreach (@exclude_categories) {
        ($subcat =~ m,.*/([^/]+)$,) and next CAT;
      }
    }
if ($cat_real eq "") {
	if ($subcat =~ m,.*/([^/]+)$,) { 
			$category_name = &build_clean($1); 
		}
		else { $category_name = &build_clean($subcat); }
	}
else { $category_name = &build_last_title_kor($cat_real); }    

    $output .= qq|  <option value="$build_root_url/$subcat/">$category_name\n|;
  }
  return $output;
}

sub go_top_category {
# --------------------------------------------------------
# ֻ īװ ̵.

  my $cat_select_list;
  open (SELECT, "<$db_script_path/data/top_cat_select.txt")
    or &cgierr("$db_script_path/data/top_cat_select.txt   . : $!");
  while (<SELECT> )
    { $cat_select_list .= $_; }
  close SELECT;
  return $cat_select_list;
}

sub site_html_cat_select_list {
# --------------------------------------------------------
  my (@subcat) = @_; 
  my $output;
                           
   foreach $subcat (sort @subcat) { 
   	($cat_real) = @{$category{$subcat}}[3];
	if ($cat_real eq "") {
		if ($subcat =~ m,.*/([^/]+)$,) { 
			$category_name = &build_clean($1); 
		} else { $category_name = &build_clean($subcat); }
	} else { $category_name = &build_clean_kor($cat_real); }
    $output .= qq|  <option value="$subcat">$category_name\n|;
  		}
  
  return $output;
}

sub get_cat_select_list {
# --------------------------------------------------------
  my $cat_select_list;
  open (SELECT, "<$db_script_path/data/cat_sel.txt")
    or &cgierr("$db_script_path/data/cat_select.txt    . : $!");
  while (<SELECT> )
    { $cat_select_list .= $_; }
  close SELECT;
  return $cat_select_list;
}

sub root_category {
    my (@subcat) = @_; 
    my ($url, $subcat, $category_name, $output);
    $output = qq|<table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr><td valign="top">\n|;

foreach $subcat (sort @subcat) { 
        $url = "$build_root_url/" . &urlencode($subcat) . "/";
        $category_name = &build_clean($subcat);
        $output .= qq|<strong><a href="$url"><font size="2">$category_name</a></font></strong> |;
        $output .= qq|<br>|;
    }
    $output .= "</td></tr></table>\n";

    return $output;
}

sub build_last_kor {
# --------------------------------------------------------
#  īװ   ѱ īװ ȯ.

     my ($input) = $_[0];
  	  my ($cat_korean, @data, @lines, $output);
  
open(DATA,"$db_category_name");
   @lines = <DATA>;
close(DATA);
	  foreach $line (@lines) {
	  		@data=split(/\|/,$line);
	  		($data[1] =~ m,.*/([^/]+)$, and $data_line = $1);
	  			if ($input eq $data_line) { 
	  				$data[3] =~ m,.*/([^/]+)$, and $cat_korean = $1; }
		}
		$output = $cat_korean;
     return $output;
 }
1;