<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xpath-default-namespace="http://www.tei-c.org/ns/1.0" version="2.0">

<!-- ref (1) To select a bracketed URL -->

  <xsl:template match="ref[@type='url']">
   <xsl:variable name="url" select="."/>
<a href="{$url}"><xsl:apply-templates/></a>
 
    </xsl:template>

<!-- ref (2) To take the target attribute as the URL to be appled to bracketed text -->

  <xsl:template match="ref[@target]"><xsl:variable name="hlink" select="@target"/><a href="{$hlink}"><xsl:apply-templates/></a></xsl:template>

  <xsl:template match="ref[@rend]"><xsl:variable name="hlink" select="@rend"/><a href="{$hlink}"><xsl:apply-templates/></a></xsl:template>

<!-- ref (3) Same structure as above, using ptr and target, like Sebastian does -->

  <xsl:template match="ptr[@target]">
    <xsl:variable name="hlink" select="@target"/>
<a href="{$hlink}"><xsl:apply-templates/></a>
    </xsl:template>

<!-- anchors -->

  <xsl:template match="anchor[@xml:id]">
    <xsl:variable name="location" select="@xml:id"/>
<a id="{$location}"><xsl:apply-templates/></a>
    </xsl:template>


<!-- Figures (1) To take the target attribute as the pointer for an image -->

  <xsl:template match="graphic[@url]">
    <xsl:variable name="graphiclink" select="@url"/>
<img src="{$graphiclink}"/><xsl:apply-templates/>
    </xsl:template>

  <xsl:template match="figure[@target]">
    <xsl:variable name="imagelink" select="@target"/>
    <img src="{$imagelink}"/><xsl:apply-templates/>
  </xsl:template>

<!--  <xsl:template match="ref">
    <xsl:if test="@url">
      <xsl:variable name="hlinkurl" select="@url"/>
      <a href="{$hlinkurl}" style="text-decoration: none" target="_blank"><xsl:apply-templates/></a>
    </xsl:if>
-->    
    <!-- But if our xref was in fact to an external link, we
      *    handle it here.
      *    But it would be better to mark up such links in their
      *    own right, not a children of an xref element
    -->
  
<!--  <xsl:apply-templates select ="a"/>
  </xsl:template>
-->
 
</xsl:stylesheet>

