<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xpath-default-namespace="http://www.tei-c.org/ns/1.0" version="2.0">
 <xsl:output method="xml" omit-xml-declaration="yes" indent="yes"/>

<xsl:template match="add">
    <sup><xsl:apply-templates/></sup>
</xsl:template>


 <xsl:template match="title">
  <xsl:choose>
   <xsl:when test="ancestor::listBibl">
    <xsl:choose>
     <xsl:when
      test="@level='m' or @level='j' or @level='s' or parent::monogr">
      <xsl:choose>
       <xsl:when test="parent::title[@level='m']">
        <span style="font-style:normal">
         <xsl:apply-templates/>
        </span>
       </xsl:when>
       <xsl:when test="parent::title[@level='a']">
        <span style="font-style:italic">
         <xsl:apply-templates/>
        </span>
       </xsl:when>
       <xsl:when test="parent::ref">
        <span style="font-style:italic">
         <xsl:apply-templates/>
        </span>
       </xsl:when>
       <xsl:when test="parent::title[@level='u']">
        <span style="font-style:italic">
         <xsl:apply-templates/>
        </span>
       </xsl:when>
       <xsl:when test="parent::gloss[@xml:lang='en']">
        <span style="font-style:italic">
         <xsl:apply-templates/>
        </span>
       </xsl:when>
       <xsl:when test="following-sibling::imprint/biblScope[@unit='vol']">
        <span style="font-style:italic">
         <xsl:apply-templates/>
        </span>
        <xsl:text> </xsl:text>
       </xsl:when>
       <xsl:when test="preceding-sibling::title[@level='a']"><xsl:text>In </xsl:text><span style="font-style:italic"><xsl:apply-templates/>. </span>
       </xsl:when>
       <xsl:otherwise>
        <span style="font-style:italic"><xsl:apply-templates/>. </span>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:when test="@type='parallel'">(<xsl:apply-templates/>) </xsl:when>
     <xsl:when
      test="@level='a' or @level='u' or parent::analytic or ancestor::biblStruct[@type='thesis']">
      <xsl:choose>
       <xsl:when test="child::gloss[@xml:lang='en']"> &#x201c;<xsl:apply-templates/>
       </xsl:when>
       <xsl:when test="substring(., string-length(.)) = '.'">
        &#x201c;<xsl:apply-templates/>&#x201d;</xsl:when>
       <xsl:when test="substring(., string-length(.)) = '?'">
        &#x201c;<xsl:apply-templates/>&#x201d;</xsl:when>
       <xsl:when test="substring(., string-length(.)) = ','">
        &#x201c;<xsl:apply-templates/>&#x201d;</xsl:when>
       <xsl:otherwise> &#x201c;<xsl:apply-templates/>.&#x201d;&#160;</xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:when test="@rend='dbrackets'">『<xsl:apply-templates/>』</xsl:when>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:choose>

     <!-- Outside of <listBibl> -->

     <xsl:when test="@level='m' or @level='j' or @level='s' or parent::monogr or parent::bibl">
      <span style="font-style:italic"><xsl:apply-templates/></span></xsl:when>
     <xsl:when test="@level='a' or @level='u'"> &#x201c;<xsl:apply-templates/>&#x201d;</xsl:when>
     <xsl:otherwise>
      <span style="font-style:italic">
       <xsl:apply-templates/>
      </span>
     </xsl:otherwise>

    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="idno"/>
 <xsl:template match="bibl">
  <xsl:choose>
   <xsl:when test="ancestor::listBibl">
    <p style="text-indent:-10mm;margin-left:10mm">
     <xsl:apply-templates/>
    </p>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <!-- Line breaks and Page breaks -->

 <xsl:template match="lb">
  <xsl:choose>
  <!--  This first case add anchors to line breaks based on the @n attribute value-->
      <xsl:when test="@n">
    <xsl:variable name="anchor" select="@n"/>
       <br/><a id="{$anchor}"/>[<xsl:value-of select="$anchor"/> ]<xsl:apply-templates/>
   </xsl:when>
   <xsl:when test="@rend='hide'">
    <xsl:apply-templates/>
   </xsl:when>
   <xsl:when test="@rend='hr'">
    <xsl:apply-templates/>
    <hr/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates/>
    <br/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="pb">
  <xsl:choose>
   <xsl:when test="@rend='display'">
    <hr/>
    <xsl:apply-templates/>
   </xsl:when>
   <xsl:when test="@rend='tno'">
    <xsl:if test="@n"> [<xsl:value-of select="@n"/>] </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="@n">
     <p style="text-align:center">[<xsl:value-of select="@n"/>] </p>
     <hr/>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>

 </xsl:template>

 <xsl:template match="lg">
  <div style="margin-top:1em; margin-bottom:1em">
   <xsl:choose>
    <xsl:when test="@rend='hide'"> </xsl:when>
    <xsl:when test="@lang='zh'">
     <span style="font-family: Mincho,'ＭＳ 明朝', BatangChe">
      <xsl:apply-templates/>
     </span>
    </xsl:when>
    <xsl:when test="rend='zh'">
     <span style="font-family: Mincho,'ＭＳ 明朝', BatangChe">
      <xsl:apply-templates/>
     </span>
    </xsl:when>
    <xsl:when test="rend='epigram'">
     <span style="font-family: 'Times New Roman'">
      <xsl:apply-templates/>
     </span>
     
    </xsl:when>
    <xsl:otherwise>
     <xsl:apply-templates/>
    </xsl:otherwise>
   </xsl:choose>
  </div>
 </xsl:template>

 <xsl:template match="foreign">
  <xsl:choose>
   <xsl:when test="@level='m' or @level='j' or @level='s'">
    <span style="font-style:normal">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:otherwise>
    <span style="font-style:italic">
     <xsl:apply-templates/>
    </span>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="gloss">
  <xsl:choose>
   <xsl:when test="parent::title[@level='m'] | parent::title[@level='j'] | ancestor::author">
    <xsl:choose>
     <xsl:when test="@xml:lang='en'">
      <span style="font-family: 'Times New Roman'; font-style:normal">
       (<xsl:apply-templates/>)</span>
     </xsl:when>
     <xsl:when test="@xml:lang='sa'"> (<span style="font-style:italic"
      ><xsl:apply-templates/></span>)</xsl:when>
     <xsl:when test="@xml:lang=('zh')">
      <span style="font-family: 'ＭＳ 明朝', Simsun, Batang; font-style:normal"><xsl:apply-templates/>
      </span>
     </xsl:when>
     <xsl:when test="@xml:lang=('ja')">
      <span style="font-family: ''ＭＳ 明朝'', Mincho; font-style:normal">
       <xsl:apply-templates/>
      </span>
     </xsl:when>
     <xsl:when test="@xml:lang=('ko')">
      <span style="font-family: Batang, BatangChe; font-style:normal">
       <xsl:apply-templates/>
      </span>
     </xsl:when>
     <xsl:otherwise>
      <span style="font-style:normal"> (<xsl:apply-templates/>)</span>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>

   <xsl:when test="parent::title[@level='a'] | parent::title[@level='u']">
    <xsl:choose>
     <xsl:when test="@xml:lang='en'">
      <span style="font-family: 'Times New Roman'; font-style:normal">&#x201d;
       (<xsl:apply-templates/>). </span>
     </xsl:when>
     <xsl:when test="@xml:lang='sa'"> (<span style="font-style:italic"
      ><xsl:apply-templates/></span>)</xsl:when>
     <xsl:when test="@xml:lang=('zh')">
      <span style="font-family: 'ＭＳ 明朝', Simsun, Batang; font-style:normal">
       <xsl:apply-templates/>
      </span>
     </xsl:when>
     <xsl:when test="@xml:lang=('ja')">
      <span style="font-family: ''ＭＳ 明朝'', Mincho; font-style:normal">
       <xsl:apply-templates/>
      </span>
     </xsl:when>
     <xsl:when test="@xml:lang=('ko')">
      <span style="font-family: Batang, BatangChe; font-style:normal">
       <xsl:apply-templates/>
      </span>
     </xsl:when>
     <xsl:otherwise>
      <span style="font-style:normal"> (<xsl:apply-templates/>)</span>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="@rend=('hide')">
   </xsl:when>
   <xsl:when test="@xml:lang=('zh')">
    <span style="font-family: 'ＭＳ 明朝', Simsun, Batang; font-style:normal">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:when test="@xml:lang=('zh-paren')"> (<span
     style="font-family: 'ＭＳ 明朝', Simsun, Batang; font-style:normal">
     <xsl:apply-templates/>
    </span>) </xsl:when>
   <xsl:when test="@xml:lang=('ja')">
    <span style="font-family: 'ＭＳ 明朝', Mincho; font-style:normal">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:when test="@xml:lang=('ko')">
    <span style="font-family: Batang, BatangChe; font-style:normal">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:when test="@xml:lang=('en')">
    <span style="font-family: 'Times New Roman'; font-style:normal">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="index"> </xsl:template>

 <xsl:template match="emph">
  <xsl:choose>
   <xsl:when test="@rend='bold'">
    <span style="font-weight:bold">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:when test="@rend='ul'">
    <span style="font-decoration:underline">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:otherwise>
    <span style="font-style:italic">
     <xsl:apply-templates/>
    </span>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="label">
  <xsl:choose>
   <xsl:when test="@rend='italic'">
    <span style="font-style:italic">
     <xsl:apply-templates/>
    </span>
   </xsl:when>

   <xsl:when test="@rend='underline'">
    <span style="text-decoration:underline">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:when test="@rend='underline-colon'">
    <span style="text-decoration:underline"><xsl:apply-templates/>: </span>
   </xsl:when>
   <xsl:when test="@rend='color-red'">
    <span style="color: rgb(204, 0, 0); font-weight:bold">[<xsl:apply-templates/>]</span>
   </xsl:when>
   <xsl:when test="@rend='colorRed'">
    <span style="color: rgb(204, 0, 0); font-weight:bold">[<xsl:apply-templates/>]</span>
   </xsl:when>
   <xsl:when test="@rend='brackets'"> [<xsl:apply-templates/>]<xsl:text> </xsl:text>
   </xsl:when>


   <xsl:when test="@rend='brackets-par'">
    <p style="margin-bottom:0em">[<xsl:apply-templates/>]</p>
   </xsl:when>

      <xsl:otherwise>
    <span style="font-weight: bold">
     [<xsl:apply-templates/>]
    </span>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="term">
  <xsl:choose>
   <xsl:when test="@rend='bold'">
    <span style="font-weight:bold">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
    <xsl:otherwise>
     <xsl:apply-templates/>
    
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="hi">
  <xsl:choose>
   <xsl:when test="@rend='italic'">
    <span style="font-style:italic">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:when test="@rend='underline'">
    <span style="text-decoration:underline">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:when test="@rend='ul'">
    <span style="text-decoration:underline">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:when test="@rend='color-red'">
    <span style="color: rgb(204, 0, 0); font-weight:bold">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:when test="@rend='colorRed'">
    <span style="color: rgb(204, 0, 0); font-weight:bold">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:when test="@rend='normal'">
    <span style="font-style: normal">
     <xsl:apply-templates/>
    </span>
   </xsl:when>
   <xsl:otherwise>
    <span style="font-weight:bold">
     <xsl:apply-templates/>
    </span>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="table">
  <xsl:choose>
   <xsl:when test="@rend='fullwidth'">
    <table style="width: 100%; border: 1px solid">
     <xsl:apply-templates/>
    </table>
   </xsl:when>
   <xsl:when test="@rend='90%'">
    <table style="width: 90%; border: 2px">
     <xsl:apply-templates/>
    </table>
   </xsl:when>
   <xsl:when test="@rend='80%'">
    <table style="width: 80%; border: 1px">
     <xsl:apply-templates/>
    </table>
   </xsl:when>
   <xsl:when test="@rend='50%'">
    <table style="width: 50%; border: 1px">
     <xsl:apply-templates/>
    </table>
   </xsl:when>
   <xsl:otherwise>
    <table style="width: 100%; border: 1px solid; col: 1 px solid">
     <xsl:apply-templates/>
    </table>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <!--
<xsl:template match="row">
<tr><xsl:apply-templates/></tr>
</xsl:template>
<xsl:template match="cell">
<td style="text-align: center; border: 1px solid"><xsl:apply-templates/></td>
</xsl:template>
-->

 <xsl:template match="quote">
  <xsl:choose>
   <xsl:when test="@rend='dq'">&#x201c;<xsl:apply-templates/>&#x201d;</xsl:when>
   <xsl:when test="@rend='dq-ul'">&#x201c;<span style="text-decoration:underline"
     ><xsl:apply-templates/></span>&#x201d;</xsl:when>
   <xsl:when test="@rend='sq'">&#x2018;<xsl:apply-templates/>&#x2019;</xsl:when>
   <xsl:when test="@rend='brackets'">
    <span style="font-family: 'ＭＳ 明朝', Batang">「<xsl:apply-templates/>」</span>
   </xsl:when>
   <xsl:when test="@rend='bq'">
    <xsl:choose>
     <xsl:when test="ancestor::note">
      <p
       style="font-size:11pt; margin-left:14mm; margin-top:1em; margin-bottom:1em; text-indent:0mm; margin-right:8mm; line-height:6mm">
       <xsl:apply-templates/>
      </p>
     </xsl:when>
     <xsl:otherwise>
      <p
       style="margin-left:16mm; margin-top:1em; margin-bottom:1em; text-indent:0mm; margin-right:2mm; font-size:12pt; line-height:9mm">
       <xsl:apply-templates/>
      </p>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="@rend='bq'">
    <p
     style="margin-left:10mm; margin-top:1em; margin-bottom:1em; text-indent:0mm; margin-right:2mm; font-size:12pt; line-height:9mm">
     <xsl:apply-templates/>
    </p>
   </xsl:when>
   <xsl:otherwise>&#160;<xsl:apply-templates/>&#160;</xsl:otherwise>
  </xsl:choose>
 </xsl:template>


</xsl:stylesheet>
