<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xpath-default-namespace="http://www.tei-c.org/ns/1.0" version="2.0">

  <xsl:variable name="cjksource">Sino-Korean Source Text</xsl:variable>
  <xsl:variable name="works">Online Works</xsl:variable>

  <xsl:template name="add-font-family">
    <xsl:attribute name="style">
    <xsl:choose>
      <xsl:when test="@xml:lang=('sa')">font-family: 'Times New Roman';</xsl:when>
      <xsl:when test="@xml:lang=('ja')">font-family:  'ＭＳ 明朝', Simsun;</xsl:when>
      <xsl:when test="@xml:lang=('zh')">font-family: 'ＭＳ 明朝', Batang, Simsun;</xsl:when>
      <xsl:when test="@xml:lang=('ko')">font-family: Batang, BatangChe;</xsl:when>
      <xsl:otherwise>font-family: 'Times New Roman';</xsl:otherwise>
    </xsl:choose>
    </xsl:attribute>
  </xsl:template> 

  <xsl:template name="add-style">
    <xsl:attribute name="style">
      <!--what is the margin component-->
      <xsl:choose>
        <xsl:when test="@rend='indent'">
          <xsl:text>text-indent:12mm; margin-top: 0;margin-bottom: 0; </xsl:text>
          <xsl:text>line-height:7mm;</xsl:text>
        </xsl:when>
        <xsl:when test="@rend='plain'">
          <xsl:text>text-indent:0;margin-left:0; margin-top:0;</xsl:text>
          <xsl:text>margin-bottom: 0; line-height:7mm;</xsl:text>
        </xsl:when>
       <xsl:when test="@rend='plainBold'">
          <xsl:text>text-indent:0;margin-left:0; margin-top:0;</xsl:text>
          <xsl:text>margin-bottom: 0; line-height:7mm; font-weight:bold</xsl:text>
        </xsl:when>
     <xsl:when test="@rend='bq'">
          <xsl:text>text-indent:0;margin-left:12mm; margin-top:1em;</xsl:text>
          <xsl:text>margin-bottom: 1em; margin-right: 2em;</xsl:text>
          <xsl:text>line-height:7mm;</xsl:text>
        </xsl:when>
     <xsl:when test="@rend='blockleft1'">
          <xsl:text>text-indent:0;margin-left:7mm; </xsl:text></xsl:when>
     <xsl:when test="@rend='blockleft2'">
          <xsl:text>text-indent:0;margin-left:12mm; </xsl:text>
        </xsl:when>
        <xsl:when test="@rend='bqNested1'">
          <xsl:text>margin-left:22mm; margin-top:0.5em; </xsl:text>
          <xsl:text> text-indent:0mm; margin-right:2mm;</xsl:text>
          <xsl:text>margin-bottom:0.5em;line-height:7mm;</xsl:text>
        </xsl:when>
        <xsl:when test="@rend='verseline'">
          <xsl:text>margin-left:12mm; margin-top:0em;</xsl:text>
          <xsl:text>margin-bottom:0em;</xsl:text>
          <xsl:text> text-indent:0mm; margin-right:12mm ; </xsl:text>
          <xsl:text>line-height:7mm;</xsl:text>
        </xsl:when>
        <xsl:when test="@rend='passage'">
          <xsl:text>margin-left:5%; margin-right:5%; margin-top:0.7em;</xsl:text>
          <xsl:text> text-indent:0mm; line-height:7mm;</xsl:text>
          <xsl:text>margin-bottom:0.7em;</xsl:text>
        </xsl:when>
        <xsl:when test="@rend='centered'">
          <xsl:text>text-align: center; margin-top: 0; margin-bottom: 0;</xsl:text>
          <xsl:text>line-height:7mm;</xsl:text>
        </xsl:when>
        <xsl:when test="@rend='right'">
          <xsl:text>text-align: right; margin-top: 0; margin-bottom: 0;</xsl:text>
        </xsl:when>
<xsl:when test="@rend='head1web'">
          <xsl:text>text-align: center; margin-top: 0; margin-bottom: 0;</xsl:text>
<xsl:text>font-size: large; color: black; margin-left:0;</xsl:text>
</xsl:when>
        <xsl:when test="@rend='note'">
          <xsl:text>font-size:90%; margin-left:0; margin-top:1em;</xsl:text>
          <xsl:text>line-height:150%; margin-bottom:0; text-indent:0mm;</xsl:text>
        </xsl:when>
        <xsl:when test="@rend='hangInd'">
          <xsl:text>text-indent:-10mm;margin-left:10mm;</xsl:text>
        </xsl:when>
        <xsl:when test="@rend='indHangInd'">
          <xsl:text>text-indent:-10mm;margin-left:15mm;</xsl:text>
        </xsl:when>
        <xsl:when test="@rend='plainTight'">
          <xsl:text>margin-left:3%; margin-top:0em; margin-bottom:0em;</xsl:text>
          <xsl:text> text-indent:0mm; line-height:130%;</xsl:text>
        </xsl:when>
        <xsl:when test="@rend='indentTight'">
          <xsl:text>margin-left:3%; text-indent:12mm; margin-top: 0;margin-bottom: 0; </xsl:text>
          <xsl:text>line-height:130%;</xsl:text>
        </xsl:when>
        <xsl:when test="@rend='abstract'">
          <xsl:text>font-size:80%; line-height:5mm; margin-bottom:0;</xsl:text>
          <xsl:text>margin-top:0;</xsl:text>
          <xsl:text> margin-left:5%; margin-right:10%;</xsl:text>
        </xsl:when>
      </xsl:choose>

      <!--what is the language component-->
      <xsl:choose>
        <xsl:when test="@xml:lang=('sa')">font-family: 'Times New Roman';</xsl:when>
        <xsl:when test="@xml:lang=('ja')">font-family:  'ＭＳ 明朝', Simsun;</xsl:when>
        <xsl:when test="@xml:lang=('zh')">font-family: 'ＭＳ 明朝', Batang, Simsun;</xsl:when>
        <xsl:when test="@xml:lang=('ko')">font-family: Batang, BatangChe;</xsl:when>
        <xsl:otherwise>font-family: 'Times New Roman';</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="p">
    <xsl:choose>
      <xsl:when test="@rend='showhide'">
        <xsl:variable name="cjknum" select="count(preceding::p[@rend='showhide'])+1"/>
        <xsl:variable name="togglelabel" select="concat('chin','-',$cjknum)"/>
        <span onclick="toggle('{$togglelabel}');return false;" style="font-size:90%">[<a href="#"
              ><xsl:value-of select="$cjksource"/></a>]</span>
        <div id="{$togglelabel}" style="display: none">
          <p style="font-family: Mincho,'ＭＳ 明朝', Simsun; font-size:110%; margin-right:5em">
            <xsl:apply-templates/>
          </p>
        </div>
      </xsl:when>

      <xsl:when test="@rend='showhide-bibl'">
        <xsl:variable name="recordnum" select="count(preceding::p[@rend='showhide-bibl'])+1"/>
        <xsl:variable name="togglelabel" select="concat('chin','-',$recordnum)"/>
        <span onclick="toggle('{$togglelabel}');return false;" style="font-size:100%">[<a href="#"
              ><xsl:value-of select="$works"/></a>]</span>
        <div id="{$togglelabel}" style="display: none">
          <p style="font-size:100%; margin-right:5em">
            <xsl:apply-templates/>
          </p>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <p>
          <xsl:call-template name="add-style"/>
          <xsl:apply-templates/>
        </p>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="epigraph">
    <hr/>
    <table rows="1" cols="1">
      <row>
        <cell>
          <xsl:apply-templates/>
        </cell>
      </row>
    </table>
  </xsl:template>

   <!-- Lists -->
  <xsl:template match="list">
    <xsl:choose>
      <xsl:when test="@type='ordered'">
        <ol style="margin-left:5%">
          <xsl:apply-templates/>
        </ol>
      </xsl:when>
      <xsl:when test="@type='ordered-note'">
        <ol style="font-size: 90%; margin-left:5%; margin-top:0.5em; margin-bottom:0.5em;">
          <xsl:apply-templates/>
        </ol>
      </xsl:when>
<xsl:when test="@type='orderedAbstract'">
<ol style="font-size:80%; line-height:5mm; margin-bottom:0; margin-top:0; margin-left:5%; margin-right:5%"><xsl:apply-templates/></ol></xsl:when>
      <xsl:when test="@type='ordered-web'">
        <ol>
          <xsl:apply-templates/>
        </ol>
      </xsl:when>
      <xsl:when test="@type='ordered-upper-roman'">
        <ol style="list-style-type: upper-roman">
          <xsl:apply-templates/>
        </ol>
      </xsl:when>
      <xsl:when test="@type='ordered-lower-roman'">
        <ol style="list-style-type: lower-roman">
          <xsl:apply-templates/>
        </ol>
      </xsl:when>

      <xsl:when test="@type='ordered-lower-alpha'">
        <ol style="list-style-type: lower-alpha">
          <xsl:apply-templates/>
        </ol>
      </xsl:when>

      <xsl:when test="@type='ordered-decimal'">
        <ol style="list-style-type: decimal; line-height:8mm">
          <xsl:apply-templates/>
        </ol>
      </xsl:when>

      <xsl:when test="@type='bulleted'">
        <ul
          style="list-style-type: disc; margin-left:5%; font-family: 'Times New Roman', ">
          <xsl:apply-templates/>
        </ul>
      </xsl:when>
      <xsl:when test="@type='simple'">
        <ul
          style="list-style-type: none; margin-left:1em; padding-left: 0; font-family: 'Times New Roman'; ">
          <xsl:apply-templates/>
        </ul>
      </xsl:when>
      <xsl:otherwise>
        <ul style="line-height:8mm; margin-left:5%">
          <xsl:apply-templates/>
        </ul>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="item">
    <li style="margin-bottom: 0.5em">
      <xsl:apply-templates/>
    </li>
  </xsl:template>

  <xsl:template match="l">
    <xsl:choose>
      <xsl:when test="ancestor::lg/@rend='verse'">
        <p style="margin-left:5em; margin-top:0.5em; margin-bottom:0.5em; line-height:6mm">
          <xsl:apply-templates/>
        </p>
      </xsl:when>
<xsl:when test="ancestor::lg/@rend='tight'">
        <p style="margin-top:0; margin-bottom:0; margin-left:inherit;text-indent:5mm; line-height:120%">
          <xsl:apply-templates/>
        </p>
</xsl:when>
<xsl:when test="ancestor::lg/@rend='epigram'">
        <p style="margin-top:0; margin-bottom:0; margin-left:inherit;text-indent:25mm; font-size:90%;line-height:120%">
          <xsl:apply-templates/>
        </p>
</xsl:when>
      <xsl:otherwise>
        <p style="margin-top:0.5em; margin-bottom:0.5em; text-indent:5mm; line-height:6mm">
          <xsl:apply-templates/>
        </p>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

    <xsl:template match="cit">
    <xsl:choose>
      <xsl:when test="@rend='display'">
        <p
          style="margin-left:10mm; margin-top:1em; margin-bottom:1em;
 text-indent:0mm; margin-right:2mm; line-height:7mm">
          <xsl:apply-templates select="q|quote"/>
          <xsl:apply-templates select="bibl"/>
        </p>
      </xsl:when>
<xsl:when test="@type='T.224'">
<br/><xsl:apply-templates/>
</xsl:when>
      <xsl:otherwise>
        <span><xsl:call-template name="add-font-family"/>      <xsl:apply-templates/></span>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="soCalled">
    <xsl:choose>
      <xsl:when test="parent::quote[@rend='dq']">&#x2018;<xsl:apply-templates/>&#x2019;</xsl:when>
      <xsl:otherwise>&#x201c;<xsl:apply-templates/>&#x201d;</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  
  <xsl:template match="row">
    <tr>
      <xsl:apply-templates/>
    </tr>
  </xsl:template>
  <xsl:template match="cell">
    <td style="text-align: center">
      <xsl:apply-templates/>
    </td>
  </xsl:template>

</xsl:stylesheet>
