<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xpath-default-namespace="http://www.tei-c.org/ns/1.0" version="2.0">

<xsl:template match="note">
    <xsl:choose>
        <xsl:when test="@place='interlinear'">
    <span style="font-size:92%; font-family:MingLiU,
    Simsum">[ <span style="font-family:Times New Roman">Interlinear Note:</span> 
   <xsl:apply-templates/>
]</span>
      </xsl:when>
      <xsl:when test="@place='inline'">
        <xsl:choose>
          <xsl:when test="parent::p[@xml:lang='zh']">
            <span style="font-size:90%; font-family:'Batang'"> [<xsl:apply-templates/>]</span></xsl:when>
          <xsl:otherwise>
            <span style="font-size:90%; font-family:'Arial'"> [<xsl:apply-templates/>]</span></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
  <xsl:when test="@place='bibl'">
    <xsl:apply-templates/>.&#160;
 </xsl:when>
<xsl:when test="@rend='paren'">
  <xsl:text> </xsl:text><span style="font-style:normal">(<xsl:apply-templates/>)</span>
</xsl:when>
<xsl:when test="@rend='brackets'">
  [<xsl:apply-templates/>]
</xsl:when>
<xsl:when test="parent::biblStruct">
 [<xsl:apply-templates/>]
</xsl:when>
</xsl:choose>
  
</xsl:template>



<!-- MB 2003-03-21  Note handling templates begin
*  We need two note handlers. The default one, for body text rendering,
*  generates :
*  a footnote number, created by counting the appropriate nodes.
*  [NB In some sorts of text, it would be more appropriate to hard-code this
*  number via the n attribute on the note element.]
*  an anchor name, so we can hyperlink back to the reference point after 
*  jumping to and reading the note
*  a hyperlink to the actual footnote text
*  a reference mark to carry that hyperlink.
*  It ignores the actual footnote text -->

<xsl:template match="note[@place='end']">
  <span style="font-family:Times New Roman">
<!-- First, count our note. This can be tricky if the desired reference markers
*    aren't sequential Arabic numerals, or if the numbering has to restart,
*    eg on each page or within each section. But here there's a continuous
*    sequence throughout the document, so a simple count will do
*    Since we need this value for link creation as well as simple output
*    we put it in a variable
-->
   <xsl:variable name="notenum" select="count(preceding::note[@place='end'])+1"/>

<!--
   Now we need to create an identifier for this note, so that we can link to 
*  and from it. The most general way is to use XSLT's generate-id() function.
*  This returns a string that uniquely identifies a given node. So we could
*  call it here where the note is referenced to generate the href value
*  for the link, then call it again from the same node when in "shownotes" 
*  mode (see below) to create the #name target of the link. But the 
*  resulting html isn't so easy to follow if manual post-editing becomes
*  necessary, so let's just use the actual footnote number as the
*  identifier for the link. However, that would break if at some stage we
*  wanted to start renumbering the notes at each section boundary (since
*  we'd then have more than one note 1 etc.) So let's keep that possiblity
*  open by creating the identifier from the parent section number as well as
*  the running note count.
-->

<!-- Get the section number into a variable -->
<xsl:variable name="secnum" select="ancestor::div1[1]/@n"/>

<!-- Some styling needed here to control the appearance of the reference
*  number  We just use <sup> for now
-->
    <span style="vertical-align:super; font-size:9pt; line-height: 9pt">
<!-- Create our identifier from the two components and put it in a variable -->

<xsl:variable name="linklabel" select="concat($secnum,'-',$notenum)"/>

<!-- Now to write the anchor and hyperlink -->
   
<!-- We need an <a> element with name and href attributes
* The name will become the target of the hyperlink back to this point
* at the end of the footnote text. The href is, of course, the identifier of
* the target footnote text. We will write a corresponding name into the 
* footnote to form the target of this link when we to process it in "shownotes"
* mode
--> 
<a>
<xsl:attribute name="id">refpoint-<xsl:value-of select="$linklabel"/></xsl:attribute>
<xsl:attribute name="href">#note-<xsl:value-of select="$linklabel"/></xsl:attribute>
<xsl:value-of select="$notenum"/>
</a>    
</span><xsl:text> </xsl:text>

<!--  We're done for now: we DON'T do an <xsl:apply-templates/>
*     because that would append the text of the footnote to the reference
*     point we've just inserted, and we don't want that text here.
--></span>
</xsl:template>


<!-- MB 2003-03-21
*  The second handler, with mode shownotes set,
*  generates :
*  an auto-generated note number [see caveat in comment to body-text
*  note template about relative merits of calculated and hard-coded numbering]
*  an anchor name, as the target of the hyperlink already inserted into the 
*  running text
*  the actual text of the footnote
*  a hyperlink back to the reference point in the body text
 -->

<xsl:template match="note[@place='end']" mode="shownotes">

   <xsl:variable name="notenum" select="count(preceding::note[@place='end'])+1"/>
<!-- any style wrapping for note text comes here: just a plain <p>
*     for now -->
  <p style="font-size:90%; margin-bottom: 1em; line-height:150%">
<!-- Output the reference no -->
<xsl:value-of select="$notenum"/><xsl:text>. </xsl:text>
<!-- write the <a>element target for the link reference
*   See comments in body-text note handler for the variables and their
*    uses.
-->
<xsl:variable name="secnum" select="ancestor::div1[1]/@n"/>
<xsl:variable name="linklabel" select="concat($secnum,'-',$notenum)"/>
<a>
<xsl:attribute name="id">note-<xsl:value-of select="$linklabel"/></xsl:attribute>
</a>    
   <xsl:apply-templates/>
<!-- Now add a backlink to the body text reference point 
<xsl:text>[</xsl:text><a>
<xsl:attribute name="href">#refpoint-<xsl:value-of select="$linklabel"/>
</xsl:attribute>
<xsl:text>back</xsl:text>
</a><xsl:text>]</xsl:text>    -->  <xsl:variable name="resp" select="@resp"/>
          <xsl:if test="@resp"> (<xsl:value-of select="$resp"/>)</xsl:if>
</p>

</xsl:template>
</xsl:stylesheet>
