<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xpath-default-namespace="http://www.tei-c.org/ns/1.0" version="2.0">
  <xsl:output method="xml" omit-xml-declaration="yes" indent="yes"/>
  
  <!-- Bibliographical renderings -->
<xsl:template match="listBibl">
  <xsl:choose>
    <xsl:when test="@rend='classics'">
      <xsl:for-each select="biblStruct">
        <xsl:sort select="descendant::title[1]"/>       
        <p style="text-indent:-10mm;margin-left:10mm">
          <xsl:if test="@n">
            <span style="font-weight:bold;margin-left:2mm">
              <xsl:value-of select="@n"/>
              <xsl:text>-&#x09;</xsl:text>
            </span>
          </xsl:if>
          <xsl:apply-templates/>
        </p>
      </xsl:for-each>
    </xsl:when>
    <xsl:otherwise>
      <xsl:for-each select="biblStruct">
        <xsl:sort select="descendant::surname[1]"/>
          <!--     <p style="text-indent:-10mm;margin-left:10mm; line-height: 200%">-->
          <p style="text-indent:-10mm;margin-left:10mm; font-size:11pt">
          <xsl:if test="@n">
            <span style="font-weight:bold;margin-left:2mm">
              <xsl:value-of select="@n"/>
              <xsl:text>-&#x09;</xsl:text>
            </span>
          </xsl:if>
          <xsl:apply-templates/>
        </p>
      </xsl:for-each>      

      <xsl:for-each select="bibl">
        <p style="text-indent:-10mm;margin-left:10mm; line-height: 200%">
          <xsl:apply-templates/>
        </p>
      </xsl:for-each>      
      
    </xsl:otherwise>
  

  </xsl:choose>

</xsl:template>
 <xsl:template match="analytic">

  <xsl:apply-templates select="author"/>
     <xsl:apply-templates select="../monogr/imprint/date"/>
  <xsl:apply-templates select="title"/>

 </xsl:template>


 <xsl:template match="monogr">
<xsl:choose>
   <xsl:when test="ancestor::listBibl[@rend='classics']">
     <xsl:apply-templates select="title"/>
     <xsl:apply-templates select="author"/>
  <xsl:apply-templates select="editor"/>
  <xsl:apply-templates select="imprint/biblScope"/>
   </xsl:when>
  <xsl:otherwise>
    <xsl:apply-templates select="author"/>
    <xsl:apply-templates select="editor"/>
      <xsl:if test="child::title[@level='m'] or child::title[@level='u']">
      <xsl:apply-templates select="imprint/date"/>
      </xsl:if>
    <xsl:apply-templates select="title"/>
    <xsl:apply-templates select="imprint/pubPlace"/>
      <xsl:apply-templates select="imprint/publisher"/>
      <xsl:apply-templates select="imprint/biblScope"/>
  </xsl:otherwise>
</xsl:choose>
 </xsl:template>
    
    <xsl:template match="imprint">
        <xsl:choose>
            <xsl:when test="ancestor::monogr[1]/title[@level='j']">
                <xsl:apply-templates select="biblScope[@unit='vol']"/>
                <xsl:apply-templates select="biblScope[@unit='issue']"/>
                    <xsl:apply-templates select="biblScope[@unit='pp']"/>
            </xsl:when>  
            <xsl:when test="ancestor::monogr[1]/title[@level='m']">
	      <xsl:apply-templates select="biblScope[@unit='vols']"/>
            <xsl:apply-templates select="biblScope[@unit='pp']"/>
              <xsl:apply-templates select="pubPlace"/>
              <xsl:apply-templates select="publisher"/>
      
   
          </xsl:when>  
          <xsl:when test="ancestor::listBibl[1][@rend='classics']">
            <xsl:apply-templates select="biblScope[@unit='fascicles']"/>
            <xsl:apply-templates select="biblScope[@unit='canonref']"/>
          </xsl:when>  
            <xsl:otherwise>
                <xsl:apply-templates select="pubPlace"/>
                <xsl:apply-templates select="publisher"/>
         
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


 <xsl:template match="monogr[@rend]">
  <xsl:variable name="monogrnote" select="@rend"/>
  <xsl:value-of select="$monogrnote"/>
  <xsl:text> </xsl:text>
  <xsl:apply-templates/>
 </xsl:template>

 <xsl:template match="imprint[@rend]">
  <xsl:variable name="imprintnote" select="@rend"/> [<xsl:value-of select="$imprintnote"
  /><xsl:text>: </xsl:text><xsl:apply-templates/>] </xsl:template>

  <xsl:template match="author">
    
    <!-- MB 2003-08-01 
      
** If our author name is the same as the
     preceding one, output a string of dashes in its place. NB
     this presupposes that identical names are indeed entered
     identically! It might also be a wise precaution to
     normalize-space both the string values we are
     comparing. Also, the "suppression marker" perhaps ought to
     be in a variable rather than hard-coded as here.
-->
    
    <xsl:variable name="fname" select="child::forename"/>
    
    
    <xsl:choose>
      <xsl:when
        test="preceding::biblStruct[1]/*/editor[1] = . or preceding::biblStruct[1]/*/author[1] = .">
        <xsl:choose>
          
          <xsl:when test="preceding::bibl[1]/author = .">
            <xsl:text>----.&#160;</xsl:text>
          </xsl:when>
          <xsl:when test="preceding::bibl[1]/editor = .">
            <xsl:text>----.&#160;</xsl:text>
          </xsl:when>
          <xsl:when test="preceding::bibl[1]/*/author = .">
            <xsl:text>----.&#160;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>----.&#160;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        
        <xsl:choose>
          <xsl:when test="child::surname">
            <xsl:choose>
              <xsl:when test="preceding-sibling::author">
                  <xsl:choose>
                      <xsl:when test="not(following-sibling::author)">
                          <xsl:text>and </xsl:text>
                          <xsl:value-of select="forename"/>
                          <xsl:text>&#160;</xsl:text>
                          <xsl:value-of select="surname"/>
                          <xsl:text>.&#160;</xsl:text>
                      </xsl:when>
                      <xsl:otherwise>
                          <xsl:value-of select="forename"/>
                          <xsl:text>&#160;</xsl:text>
                          <xsl:value-of select="surname"/>
                          <xsl:text>,&#160;</xsl:text>
                      </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:when test="following-sibling::author">
                    <xsl:value-of select="surname"/>, <xsl:value-of select="forename"
                    /><xsl:text>,&#160;</xsl:text>
                </xsl:when>
                <xsl:when test="substring($fname, string-length($fname)) = '.'">
                    <xsl:value-of select="surname"/>, <xsl:value-of select="forename"
                    /><xsl:text>&#160;</xsl:text>
                </xsl:when>
              <xsl:when test="ancestor::biblStruct[@xml:lang='ea' or @lang='ea']">
                <xsl:value-of select="surname"/><xsl:text>&#160;</xsl:text><xsl:value-of select="forename"
                /><xsl:if test="child::gloss"><xsl:text>&#160;</xsl:text><xsl:value-of select="gloss"/></xsl:if><xsl:text>.&#160;</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="surname"/>, <xsl:value-of select="forename"
                /><xsl:text>.&#160;</xsl:text>
              </xsl:otherwise>
              
            </xsl:choose>
          </xsl:when>
          <xsl:when test="child::name">
            <xsl:apply-templates/>
            <xsl:text>.&#160;</xsl:text>
          </xsl:when>
          <xsl:when test="substring(., string-length(.)) = '.'">
            <xsl:apply-templates/>
            <xsl:text>&#160;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates/>
            <xsl:text>.&#160;</xsl:text>            
          </xsl:otherwise>
        </xsl:choose>
        
      </xsl:otherwise>
        </xsl:choose>
  </xsl:template>
    
    <xsl:template match="editor">
      <xsl:variable name="edfname" select="child::forename"/>
    <xsl:choose>
      <xsl:when
        test="preceding::biblStruct[1]/*/editor = . or preceding::biblStruct[1]/*/author = .">
        <xsl:choose>
          <xsl:when test="@role='trans'">
            <xsl:text>----, trans.&#160;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="following-sibling::editor">
                <xsl:text>---- and </xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>----, ed.&#160;</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="@role='trans'">
          <xsl:choose>
              <xsl:when test="child::surname">
                  <xsl:choose>
                      <xsl:when test="preceding-sibling::editor">
                          <xsl:choose>
                              <xsl:when test="not(following-sibling::editor)">
                                  <xsl:text>and </xsl:text>
                                  <xsl:value-of select="forename"/>
                                  <xsl:text>&#160;</xsl:text>
                                  <xsl:value-of select="surname"/>
                                  <xsl:text>, trans.&#160;</xsl:text>
                              </xsl:when>
                              <xsl:otherwise>
                                  <xsl:value-of select="forename"/>
                                  <xsl:text>&#160;</xsl:text>
                                  <xsl:value-of select="surname"/>
                                  <xsl:text>,&#160;</xsl:text>
                              </xsl:otherwise>
                          </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                          <xsl:choose>
                              <xsl:when test="following-sibling::editor">
                                  <xsl:value-of select="surname"/>, <xsl:value-of select="forename"
                                  /><xsl:text>,&#160;</xsl:text>
                              </xsl:when>
                              <xsl:otherwise>
                                  <xsl:value-of select="surname"/>, <xsl:value-of select="forename"
                                  /><xsl:text>, trans.&#160;</xsl:text>
                              </xsl:otherwise>
                          </xsl:choose>
                      </xsl:otherwise>
                  </xsl:choose>
              </xsl:when>
          </xsl:choose>
      </xsl:when>
         <xsl:otherwise>
        <xsl:choose>
            <xsl:when test="child::surname">
                <xsl:choose>
                    <xsl:when test="preceding-sibling::editor">
                        <xsl:choose>
                            <xsl:when test="not(following-sibling::editor)">
                                <xsl:text> </xsl:text>
                                <xsl:value-of select="forename"/>
                                <xsl:text>&#160;</xsl:text>
                                <xsl:value-of select="surname"/>
                                <xsl:text>, eds.&#160;</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="forename"/>
                                <xsl:text>&#160;</xsl:text>
                                <xsl:value-of select="surname"/>
                                <xsl:text>,&#160;</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                        <xsl:when test="following-sibling::editor">
                            <xsl:value-of select="surname"/>, <xsl:value-of select="forename"
                            /><xsl:text>,&#160;</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                        <xsl:value-of select="surname"/>, <xsl:value-of select="forename"
                        /><xsl:text>, ed.&#160;</xsl:text>
                    </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

 <xsl:template match="monogr[@rend]">
  <xsl:variable name="monogrnote" select="@rend"/>
  <xsl:value-of select="$monogrnote"/>
  <xsl:text> </xsl:text>
  <xsl:apply-templates/>
 </xsl:template>

 <xsl:template match="imprint[@rend]">
  <xsl:variable name="imprintnote" select="@rend"/> [<xsl:value-of select="$imprintnote"
  /><xsl:text>: </xsl:text><xsl:apply-templates/>] </xsl:template>

 <xsl:template match="edition">
  <xsl:apply-templates/>
  <xsl:text>. </xsl:text>
 </xsl:template>

 <xsl:template match="pubPlace">
     <xsl:choose>
         <xsl:when test="ancestor::monogr/title[@level='u']">
             <xsl:apply-templates/>. 
         </xsl:when>
         <xsl:otherwise>
                 <xsl:apply-templates/>:&#160;
         </xsl:otherwise>
     </xsl:choose>
</xsl:template> 
 <xsl:template match="publisher">
<xsl:choose>
 <xsl:when test="ancestor::monogr[1]/title[@level='j']"><xsl:apply-templates/>&#160;
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates/>.
</xsl:otherwise>
</xsl:choose>
 </xsl:template>
  
  <xsl:template match="date">
    <xsl:choose>
      <xsl:when test="(parent::p)">
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>. </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
 <xsl:template match="biblScope">
  <xsl:choose>
   <xsl:when test="ancestor::listBibl">
    <xsl:choose>
      <xsl:when test="@unit='vol' or @unit='volume'">
      <xsl:choose>
       <xsl:when test="ancestor::monogr[1]/title[@level='j']"
        ><xsl:apply-templates/>&#160;</xsl:when>
       <xsl:otherwise> <xsl:apply-templates/>, 
       </xsl:otherwise>
      </xsl:choose>
      </xsl:when>
            <xsl:when test="@unit='vols'">
    <xsl:apply-templates/>&#160;vols. </xsl:when>
       <xsl:when test="@unit='pp' or @unit='pages'">
      <xsl:choose>
       <xsl:when test="ancestor::monogr[1]/title[@level='j']"><xsl:apply-templates/>. </xsl:when>
       <xsl:when test="ancestor::monogr[1]/title[@level='m']"><xsl:apply-templates/>. </xsl:when>
       <xsl:otherwise>pp. <xsl:apply-templates/>. </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:when test="@unit='canonref'">
      <xsl:apply-templates/>. </xsl:when>
      <xsl:when test="@unit='fascicles'">
        <xsl:apply-templates/>, </xsl:when>
     <xsl:when test="@unit='issue'"> (<xsl:apply-templates/>): </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates/>
      <xsl:text> </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="ancestor::cit | ancestor::p | ancestor::quote | ancestor::lg">
    (<xsl:apply-templates/>) </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

</xsl:stylesheet>
