<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xpath-default-namespace="http://www.tei-c.org/ns/1.0" version="2.0">
  <xsl:template match="TEI">
   <html>
<xsl:comment>
      This file has been generated from an XML master, and will be updated from that. It is not profitable to spend time editing this file.
    </xsl:comment>
    <head>
             <meta charset="utf-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<!-- Some script to toggle the display of the element whose id is passed in -->
  <script type="text/javascript">
    function toggle(id)
      {
        element = document.getElementById(id);
        if (element.style.display == 'none')
         {
           element.style.display = 'block';
         }
        else
         {
          element.style.display = 'none';
        }
    }
  </script>

<style type="text/css">
<xsl:comment>
<xsl:value-of select="document('styles-web.xml')//*"/>
</xsl:comment>
</style>
  <title><xsl:value-of select="teiHeader/fileDesc/titleStmt/title"/></title>
      </head>
      <body>
        <p><a href="../index.html">top page</a></p>
<!-- Start HTML presented front matter -->
    <xsl:apply-templates select="text/front"/>

<!--end HTML presented front matter -->
          <p>[Updated: <xsl:value-of  select="current-dateTime()"/>]</p>
        <xsl:apply-templates select="text/body"/>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="body">

    <!-- Beginning of placement for TOC -->
    <hr/>
    <xsl:if test="//div1/head">
    <p style="text-align:center; color:teal;font-size:120%; font-family:'Times New Roman'">Table of Contents</p>
<!-- MB 2003-03-22 Use a table so we can align the numbers and the titles correctly -->
<table style="border-style: none">
  <xsl:for-each select="//div1/head">
<xsl:apply-templates  select="."  mode="showheads"/>
</xsl:for-each>
</table>
</xsl:if>
 <!-- Ending of placement for TOC -->

    <xsl:apply-templates select="div1"/>

<!-- MB 2003-03-21
* This invokes the display of the footnote contents. The current placing
* means they appear as the very last thing, but that can be altered
* NB This is the sort of thing that <xsl:foreach> is really meant for.
* We gather as set of nodes (here the footnotes) and iterate over them
* i.e. do the same thing to each of them, one by one. The crucial thing
* is that our apply-templates sets the "shownotes" mode. This means
* that the nodes are handled not by the default note-handling template,
* but by the special "shownotes" one. See the actual note templates
* below for further explanation.
-->
<xsl:if test="//note[@place='end']">
  <hr/>
<p style="color:teal; font-size:120%">Notes</p>
<xsl:for-each select="//note[@place='end']">
<xsl:apply-templates  select="."  mode="shownotes"/>
</xsl:for-each>
</xsl:if>
<!-- Footnote rendering invocation ends-->

<!-- Creative Commons License

<hr/>
<p style="text-align:center"><a href="http://creativecommons.org/licenses/by-nc-sa/1.0"><img
  alt="Creative Commons License" src="http://creativecommons.org/images/public/somerights.gif"/></a> </p>
 <p style="text-align:center">This document is licensed under a <a
  href="http://creativecommons.org/licenses/by-nc-sa/1.0">Creative
  Commons License</a></p>
-->


 <!-- /Creative Commons License -->

 
<!-- Copyright Notice -->
<!-- 
<p style="text-align:center;" rend="border-above">Copyright &#169; Charles Muller&#x2014; 2012</p>
-->
</xsl:template>

  <!-- Divs to TOC-->
  <xsl:include href="divhandler-web.xsl"/>
 <!-- <xsl:include href="tei-html/html_textstructure.xsl"/>-->
  <!-- Header and Front -->
 <xsl:include href="TEIHeader-web.xsl"/>

<!-- Beginning of modified endnote handling templates -->
  <xsl:include href="endnote-handler-web.xsl"/>

 <!-- global body formatting -->
 <xsl:include href="global-body-web.xsl"/>
<xsl:include href="global-shared.xsl"/>
<xsl:include href="biblStruct.xsl"/>
 <xsl:include href="hyperlinking.xsl"/>
  
  <!-- 
<xsl:include href="tei-dictionary.xsl"/> -->
</xsl:stylesheet>
